//=============================================================================
// FullCare.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 「まんたん」の実装。
 * @author まっつＵＰ
 *
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * （プラグインコマンド）
 * command:FullCare
 * args:0・・・アクターのmhpに対するhpの比
 * 
 * 例：FullCare 90
 * 回復スキルの使用条件を許す限り
 * パーティ全員のhpをmhpの90%以上になるまで回復する。
 * 
 * スキルのノートタグ
 * <FCunableS>
 * このノートタグを記述することで
 * プラグインコマンド実行時の使用対象のスキルになりません。
 * 
 * 治療スキル使用者はindexの大きい順に走査して決めます。
 * 各治療スキル使用者は
 * ダメージタイプがなしまたはHP回復で
 * かつ各治療項目で使用条件を満足するスキルの内
 * 一番少ないmpまたはtp消費のスキルを選んで使います。
 * なお、コモンイベントが使用効果に含まれる場合も選ばれません。
 * 
 * 以下の順で回復作業します。
 * 
 * ・戦闘不能の回復
 * index順に回復します。
 * スキル対象は戦闘不能または味方全体の戦闘不能です。
 * 
 * ・ステートの解除
 * index順に回復します。
 * スキル対象は味方単体または味方全体です。
 * 
 * ・hpの回復
 * mhpに対するhpの比が小さいアクターから
 * 回復します。
 * スキル対象は味方単体または味方全体です。
 * 
 * プラグインコマンドによって
 * どれくらいの比以上になるまで
 * 回復するか決めることができます。
 * 
 * 注意:データベース上ダメージタイプがなしの場合でも
 * 以前に別のダメージタイプでダメージ計算式を設定していた場合
 * 回復スキルの計算式とみなされることがあります。
 * ダメージタイプ無しのスキルはあらかじめご確認ください。
 * 
 * このプラグインを利用する場合は
 * readmeなどに「まっつＵＰ」の名を入れてください。
 * また、素材のみの販売はダメです。
 * 上記以外の規約等はございません。
 * もちろんツクールMVで使用する前提です。
 * 何か不具合ありましたら気軽にどうぞ。
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

(function() {
    
//var parameters = PluginManager.parameters('FullCare');

var _Game_Interpreter_pluginCommand =
    Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    switch(command){

        case 'FullCare':
        var rate = Number(args[0], 100) / 100;
        $gameParty.FCcareall(rate);
        break;

    }
};

DataManager.isCommonexclude = function(skill) {
    return skill.effects.every(function(effect) {
        return effect.code !== Game_Action.EFFECT_COMMON_EVENT;
    });
};

DataManager.isRemovestateId = function(skill, stateId) {
    return skill.effects.some(function(effect) {
        return effect.code === Game_Action.EFFECT_REMOVE_STATE && effect.dataId === stateId;
    });
};

DataManager.isRecinclude = function(skill) {
    return skill.effects.some(function(effect) {
        return effect.code === Game_Action.EFFECT_RECOVER_HP;
    });
};

Game_Actor.prototype.isMustcare = function(rate) {
    return this.hpRate() < rate && this.rec > 0;
};

Game_Actor.prototype.usableCare = function(carescope) {
    var array = this.usableSkills().filter(function(skill) {
        return (skill.damage.type === 0 || skill.damage.type === 3) &&
               (carescope.contains(skill.scope) &&
                !skill.note.match(/<FCunableS>/i) &&
                DataManager.isCommonexclude(skill));
    }, this);
    array.sort(function(a, b) {
        var p1 = a.mpCost;
        var p2 = b.mpCost;
        if (p1 !== p2) {
            return p1 - p2;
        }
        return a - b;
    });
    array.sort(function(a, b) {
        var p1 = a.tpCost;
        var p2 = b.tpCost;
        if (p1 !== p2) {
            return p1 - p2;
        }
        return a - b;
    });
    return array;
};

Game_Actor.prototype.usableCarestate = function(scope, stateId) {
    return this.usableCare(scope).filter(function(skill) {
        return DataManager.isRemovestateId(skill, stateId);
    }, this);
};

Game_Actor.prototype.usableCarehp = function(scope) {
    return this.usableCare(scope).filter(function(skill) {
        return skill.damage.formula !== "0" || DataManager.isRecinclude(skill);
    }, this);
};

var _Game_Party_initialize = Game_Party.prototype.initialize;
Game_Party.prototype.initialize = function() {
    _Game_Party_initialize.call(this);
    this._FCuser = [];
    this._FCallmember = [];
    this._FCcanany = false;
};

Game_Party.prototype.FCcareall = function(rate) {
    SoundManager.playUseSkill();
    this.FCdeadstatecare();
    this.FCstatecare();
    this.FChpcare(rate);
};

Game_Party.prototype.FCsetuser = function() {
    this._FCuser = this.movableMembers();
    this._FCuser.reverse();
    this._FCcanany = true;
};

Game_Party.prototype.iscanuseany = function() {
    return this._FCcanany;
};

Game_Party.prototype.FCsetmember = function(rate) {
    this._FCallmember = this.aliveMembers();
    this._FCallmember = this._FCallmember.filter(function(member) {
        return member.isMustcare(rate);
    });
    this._FCallmember.sort(function(a, b) {
        var p1 = a.hpRate();
        var p2 = b.hpRate();
        if (p1 !== p2) {
            return p1 - p2;
        }
        return a - b;
    });
};

Game_Party.prototype.FCdeadstatecare = function() {
    this.deadMembers().forEach(function(member) {
        this.FCstatecareUse(member);
    }, this);
};

Game_Party.prototype.FCstatecare = function() {
    this.aliveMembers().forEach(function(member) {
        this.FCstatecareUse(member);
    }, this);
};

Game_Party.prototype.FCstatecareUse = function(member) {
    this.FCsetuser();
    var list = [];
    var scope = [];
    if(member.isDeathStateAffected()){
        list = [member.deathStateId()];
        scope = [9,10];
    }else{
        list = member._states;
        scope = [7,8];
    }
    this.FCrealusestate(member, scope, list);
};

Game_Party.prototype.FCrealusestate = function(member, scope, list) {
    list.forEach(function(stateId) {
        do {
            this._FCcanany = false;
            this._FCuser.forEach(function(user) {
                if(member.isStateAffected(stateId) && !this.iscanuseany()){
                    var array = user.usableCarestate(scope, stateId)
                    this.FCcareapply(user, member, array);
                }
            }, this);
        } while (member.isStateAffected(stateId) && this.iscanuseany());
    }, this);
};

Game_Party.prototype.FChpcare = function(rate) {
    this.FCsetuser();
    this.FCsetmember(rate);
    var scope = [7,8];
    this._FCallmember.forEach(function(member) {
         do {
            this._FCcanany = false;
            this._FCuser.forEach(function(user) {
                if(member.isMustcare(rate) && !this.iscanuseany()){
                    var array = user.usableCarehp(scope);
                    this.FCcareapply(user, member, array);
                }
            }, this);
        } while (member.isMustcare(rate) && this.iscanuseany());
    }, this);
};

Game_Party.prototype.FCcareapply = function(user, member, array) {
    if(array.length <= 0) return;
    this._FCcanany = true;
    var action = new Game_Action(user);
    user.useItem(array[0]);
    action.setItemObject(array[0]);
    if(action.isForAll()){
        member = this.members();
    }else{
        member = [member];
    }
    member.forEach(function(target) {
        for (var i = 0; i < action.numRepeats(); i++) {
            action.apply(target);
        }
    }, this);
};

})();
